#!/system/bin/sh
sleep 5
if [ ! -f "/config/sshserverenable" ];then
	setprop sys.sshserver.enable false
else
	setprop sys.sshserver.enable true
fi

while [ true ]
do
	sshEnable=`getprop sys.sshserver.enable`
	output=`ps | grep dropbear | grep -v grep | grep -v dropbear.sh` 
	if [ "$sshEnable" == "true" ]; then
		if [ ! -n "$output" ];then
			root_dir=
			dropbear_dir=$root_dir/data/data/dropbear

			mkdir -p $dropbear_dir
			mkdir -p $dropbear_dir/.ssh/

			touch $dropbear_dir/.ssh/authorized_keys

			busybox chmod -R 644 $dropbear_dir

			if [ ! -f $dropbear_dir/dropbear_rsa_host_key ]; then
				/system/bin/dropbearkey -t rsa -f $dropbear_dir/dropbear_rsa_host_key
			else 
				len=`busybox wc -c /data/data/dropbear/dropbear_rsa_host_key | busybox awk '{print $1}'`
				if [ $len -lt 200 ]; then
					rm -f /data/data/dropbear/dropbear_rsa_host_key
					/system/bin/dropbearkey -t rsa -f $dropbear_dir/dropbear_rsa_host_key
				fi
			fi

			if [ ! -f $dropbear_dir/dropbear_dss_host_key ]; then
				/system/bin/dropbearkey -t dss -f $dropbear_dir/dropbear_dss_host_key
			else
				len=`busybox wc -c /data/data/dropbear/dropbear_dss_host_key | busybox awk '{print $1}'`
				if [ $len -lt 200 ]; then
					rm -f /data/data/dropbear/dropbear_dss_host_key
					/system/bin/dropbearkey -t dss -f $dropbear_dir/dropbear_dss_host_key
				fi
			fi

			/system/bin/dropbear -r /data/data/dropbear/dropbear_rsa_host_key -d /data/data/dropbear/dropbear_dss_host_key -p:22 -R -A -N root
		fi
	else
		if [ -n "$output" ];then
			killall dropbear
		fi
	fi

	sleep 5
done
