#! /system/bin/sh

# Vendor Path
pathList="/vendor/app /vendor/data/app"

# Set path
updateApp=$1
if [ ! -f $updateApp ]; then
    exit 1
fi

filePath=$(dirname $updateApp)
fileName=$(basename $updateApp)

for curPath in $pathList
do
    for curFile in `ls $curPath`
    do
        if [ ! -d $curFile ]; then
            if [ $curFile == $fileName ]; then
                # find it, mount to write
                mount -o remount,rw /vendor
                cp $filePath/$fileName $curPath/$curFile
                chmod 777 $curPath/$curFile
                mount -o remount,ro /vendor
                exit 0
            fi
        fi
    done
done

exit 1
