#! /system/bin/sh
# Set Default Input Method

db_path="/data/data/com.android.providers.settings/databases/settings.db"
set_flag="/config/set_default_input_method_disable"
apk_path="/system/priv-app/GooglePinyinInputMethod/GooglePinyinInputMethod.apk"

vendor_akchina=`cat /system/app.akuvox/factory/Static/System/General.conf | grep -a "AKCHINA"`
vendor_unicom=`cat /system/app.akuvox/factory/Static/System/General.conf | grep -a "UNICOM"`

if [ ! -f $set_flag ]; then
	while [ true ]
	do
	    if [ -z $vendor_akchina ] && [ -z $vendor_unicom ];then
		   break;
		fi
		if [ -f $db_path ]; then
			sql_select="select value from secure where name='default_input_method';"
			export sqlitedb="sqlite3 $db_path"
			value=$($sqlitedb <<EOF
			$sql_select
.quit
EOF
			)
			if [ $value ]; then
				if [ -f $apk_path ]; then
					sql="update secure set value='com.google.android.inputmethod.pinyin/.PinyinIME' where name='default_input_method' OR name='enabled_input_methods';"
					export sqlitedb="sqlite3 $db_path"
					$sqlitedb <<EOF
					$sql
.quit
EOF
					busybox killall system_server
				fi
				break
			fi
		fi
		sleep 1
	done
	touch $set_flag
fi