#! /system/bin/sh

# Vendor Path
pathList="/vendor/app /vendor/data/app"

# Set path
updateApp=$1
if [ ! -f $updateApp ]; then
    exit 1
fi

filePath=$(dirname $updateApp)
fileName=$(basename $updateApp)

for curPath in $pathList
do
    for curFile in `ls $curPath`
    do
        if [ ! -d $curFile ]; then
            if [ $curFile == $fileName ]; then
                # find it, don't add
                exit 1
            fi
        fi
    done
done

mount -o remount,rw /vendor
cp $filePath/$fileName /vendor/data/app/$fileName
chmod 777 /vendor/data/app/$fileName
mount -o remount,ro /vendor
exit 0
